/**
 * Module's JavaScript.
 */

var rpt_fp = null;

function initReports()
{
	window.addEventListener('popstate', function() {
		rptUpdateFromUrl();
		rptRefresh();
	});
	
	$(document).ready(function(){

		rpt_fp = $('.rpt-filter-date').flatpickr({
			onChange: function(selectedDates, dateStr, instance) {
				$('.rpt-filter :input[name="period"]').val('custom').trigger('change');
			}
		});

		rptUpdateFromUrl();
		rptRefresh();

		// Custom fields dates
		$('#rpt-filters .input-date').flatpickr({allowInput: true});

		$('#rpt-btn-loader').click(function(e) {
			rptRefresh();
		});

		$('#rpt-btn-clear').click(function(e) {
			e.preventDefault();
			window.location = window.location.origin + window.location.pathname;
		});

		$('.rpt-filter :input').change(function(e) {
			rptOnFilterChange(e.target.name, e.target.value);
			rptRefresh();
		});
		

		$('.rpt-filter select[name="mailbox"]:first').change(function(e) {
			rptShowMailboxCustomFields($(this).val());
		});

		rptChartInit();

		$('#rpt-filters select[name="user"]').select2();
	});
}

function rptShowMailboxCustomFields(mailbox_id)
{
	$('.rpt-cf-mailbox').addClass('hidden');
	$('.rpt-cf-mailbox-'+mailbox_id).removeClass('hidden');
}

function rptOnFilterChange(target_name, target_value)
{
	if ('URL' in window) {
		var url = new URL(window.location);
		url.searchParams.set(target_name, target_value);
		window.history.pushState(null, '', url);
	}
	if ('period' === target_name) {
		var period = target_value;
		if ('custom' === period) {
			return;
		} else {
			var dates = rptUpdateDateRange(period);
			if (rpt_fp) {
				rpt_fp[0].setDate(dates.start);
				rpt_fp[1].setDate(dates.end);
			}
		}
	} else if ('mailbox' === target_name) {
		var cur_mailbox = parseInt(target_value);
		$('.rpt-filter select[name="user"] option').each(function() {
			var mailboxes = $(this).data('mailboxes');
			var disabled = true;
			if (cur_mailbox && !isNaN(cur_mailbox) && typeof(mailboxes) != "undefined" && mailboxes) {
				mailboxes_map = mailboxes.toString().split(',').map(id => parseInt(id.trim()));
				disabled = !mailboxes_map.includes(cur_mailbox);
			}
			if (disabled) {
				$(this).attr('disabled', 'disabled');
			} else {
				$(this).removeAttr('disabled');
			}
		});
		$('#rpt-filters select[name="user"]').select2();
		rptShowMailboxCustomFields(target_value);
	}
}

function rptUpdateFromUrl()
{
	if ('URL' in window) {
		var url = new URL(window.location);
		url.searchParams.forEach(function(value, key) {
			$('.rpt-filter :input[name="'+key+'"]').val(value);
			rptOnFilterChange(key, value);
		});
	}
}

function rptUpdateDateRange(selectedPeriod)
{
	var currDate  = new Date(),
		startDate = null,
		endDate   = null,
		subtractDays = (date, days) => new Date(date.getTime() - (days * 86400000)),
		periods = {
			today: () => {
				startDate = currDate;
				endDate   = startDate;
			},
			yesterday: () => {
				startDate = subtractDays(currDate, 1);
				endDate   = startDate;
			},
			last_7: () => {
				var yesterday = subtractDays(currDate, 1);
				endDate       = yesterday;
				startDate     = subtractDays(yesterday, 6);
			},
			last_week: () => {
				var prevSun = new Date(currDate.setDate(currDate.getDate() - currDate.getDay()));
				endDate       = subtractDays(prevSun, 1);
				startDate     = subtractDays(endDate, 6);
			},
			this_month: () => {
				endDate   = currDate;
				startDate = new Date(currDate.getFullYear(), currDate.getMonth(), 1);
			},
			last_month: () => {
				endDate = subtractDays(new Date(currDate.getFullYear(), currDate.getMonth(), 1), 1);
				startDate = new Date(endDate.getFullYear(), endDate.getMonth(), 1);
			},
			last_12_months: () => {
				endDate = subtractDays(new Date(currDate.getFullYear(), currDate.getMonth(), 1), 1);
				startDate = new Date(endDate.getFullYear(), endDate.getMonth() - 11, 1);
			},
			this_year: () => {
				endDate   = currDate;
				startDate = new Date(currDate.getFullYear(), 0, 1);
			},
		};

	if (typeof(periods[selectedPeriod]) != "undefined") {
		periods[selectedPeriod]();
		return {
			start: startDate, 
			end: endDate,
		};
	}

	return null;
}

function rptRefresh()
{
	var data = {};

	var loader = $('#rpt-btn-loader');

	data.action = 'report';
	data.report_name = $('#rpt-report').attr('data-report-name');
	data.filters = {};
	var filters = $('#rpt-filters').serializeArray();
	// Something went wrong
	if (!filters.length) {
		return;
	}
	for (var i in filters) {
		var filter = filters[i];
		var m = filter.name.match(/^custom_field\[(\d+)\]$/);
		if (m && typeof(m[1]) != "undefined") {
			// Miss hidden custom fields
			if (!$('.rpt-filter :input[name="'+filter.name+'"]').parent().is(":visible")) {
				continue;
			}
			if (typeof(data.filters['custom_field']) == "undefined") {
				data.filters['custom_field'] = {};
			}
			data.filters['custom_field'][m[1]] = filter.value;
		} else {
			data.filters[filter.name] = filter.value;
		}
	}
	data.chart = {};
	data.chart.group_by = $('#rpt-group-by button.active').val();
	data.chart.type = $('#rpt-chart-type').val();

	fsDoAction('reports.before_refresh', {data: data});

	loader.attr('disabled', 'disabled').children('.glyphicon:first').addClass('glyphicon-spin');
	$('.rpt-filter :input').attr('disabled', 'disabled');
	$('#rpt-options :input').attr('disabled', 'disabled');

	fsAjax(data, 
		laroute.route('reports.ajax'), 
		function(response) {
			if (isAjaxSuccess(response) && response.report) {
				$('#rpt-report').html(response.report);
				var chart_type = $('#rpt-report').attr('data-chart-type');
				if (chart_type == 'pie') {
					rptShowChartPie(response.chart);
				} else if (chart_type == 'column') {
					rptShowChartColumn(response.chart);
				} else {
					rptShowChart(response.chart);
				}
				initTooltips();

				$('#rpt-group-by button').click(function(e) {
					if ($(this).hasClass('active')) {
						return;
					}
					$('#rpt-group-by button').removeClass('active');
					$(this).addClass('active');
					rptRefresh();
				});
				$('#rpt-chart-type').change(function(e) {
					rptRefresh();
				});
				$('.rpt-user-btn').click(function(e) {
					var id = $(this).data('uid');
					$('#rpt-filters select[name="user"]').val(id).trigger('change');
				});
			} else {
				showAjaxResult(response);
			}
			loader.removeAttr('disabled').children('.glyphicon:first').removeClass('glyphicon-spin');
			$('.rpt-filter :input').removeAttr('disabled');
			$('#rpt-options :input').removeAttr('disabled');
		}, true,
		function(response) {
			showAjaxResult(response);
			loader.removeAttr('disabled').children('.glyphicon:first').removeClass('glyphicon-spin');
			$('.rpt-filter :input').removeAttr('disabled');
			$('#rpt-options :input').removeAttr('disabled');
		}
	);
}

function rptChartInit()
{
	// Add padding below legends
	Chart.register({
		id: 'paddingBelowLegends',
		beforeInit: function(chart, options) {
		    // Get a reference to the original fit function
		    const originalFit = chart.legend.fit;

		    // Override the fit function
		    chart.legend.fit = function fit() {
				// Call the original function and bind scope in order to use `this` correctly inside it
				originalFit.bind(chart.legend)();
				// Change the height as suggested in other answers
				this.height += 20;
		    }
		}
	});
}

function rptShowChart(data)
{
	/*var data = {
	  labels: data.labels,
	  datasets: [
	    {
	      label: 'Dataset 1',
	      data: Utils.numbers(NUMBER_CFG),
	      borderColor: Utils.CHART_COLORS.red,
	      backgroundColor: Utils.transparentize(Utils.CHART_COLORS.red, 0.5)
	    },
	    {
	      label: 'Dataset 2',
	      data: Utils.numbers(NUMBER_CFG),
	      borderColor: Utils.CHART_COLORS.blue,
	      backgroundColor: Utils.transparentize(Utils.CHART_COLORS.blue, 0.5)
	    }
	  ]
	};*/

	var config = {
		type: 'line',
		data: {
			labels: data.labels,
			datasets: data.datasets
		},
		options: {
			locale: $('html:first').attr('lang'),
			responsive: true,
		    interaction: {
				mode: 'index',
				intersect: false,
		    },
		    stacked: false,
		    plugins: {
				title: {
					display: false,
					text: ''
				},
				tooltip: {
					backgroundColor: '#f8f8f8',
					borderWidth: 1,
					borderColor: '#7cb5ec',
					titleColor: '#333333',
					bodyColor: '#333333',
					boxPadding: 5
				},
				legend: {
					labels: {
						pointStyle: 'circle',
						usePointStyle: true
						// boxWidth: 12,
						// boxHeight: 12
						//padding: 100
						//pointStyleWidth: 7
					}
				},
				paddingBelowLegends: true
		    },
		    scales: {
				y: {
					type: 'linear',
					display: true,
					position: 'left',
		            ticks: {
						callback: function(value) {
							// Make ticks integer.
							if (value % 1 === 0) {
								return value;
							} else {
								return '';
							}
						}
		            }
				},
				x: {
					grid: {
			        	display: false
			        }
				}
		    }
		}
    };

	// var max = 0;
	// if (typeof(data.datasets[0]) != "undefined"
	// 	&& typeof(data.datasets[0].data) != "undefined"
	// ) {
	// 	max = Math.max(...data.datasets[0].data);
	// }
	// if (typeof(data.datasets[1]) != "undefined"
	// 	&& typeof(data.datasets[1].data) != "undefined"
	// ) {
	// 	if (Math.max(...data.datasets[1].data) > max) {
	// 		max = Math.max(...data.datasets[1].data);
	// 	}
	// }
	// if (max > 0) {
	// 	config.options.scales.y.max = max+1;
	// }

	new Chart($('#rpt-chart')[0], config);
}

function rptLegendPadding()
{
	Chart.Legend.prototype.afterFit = function() {
	    this.height = this.height + 20;
	};
}

function rptShowChartPie(data)
{
	var config = {
		type: 'pie',
		data: {
			labels: data.labels,
			datasets: data.datasets
		},
		options: {
			locale: $('html:first').attr('lang'),
			responsive: true,
		    plugins: {
				title: {
					display: false,
					text: ''
				},
				tooltip: {
					backgroundColor: '#f8f8f8',
					borderWidth: 1,
					borderColor: '#7cb5ec',
					titleColor: '#333333',
					bodyColor: '#333333',
					boxPadding: 5,
					callbacks: {
	                    label: function(context) {
	                        var label = '';
	                        if (context.parsed !== null) {
	                            label = label+context.parsed+'%';
	                        }
	                        return label;
	                    }
	                }
				},
				legend: {
					labels: {
						boxWidth: 12
					}
				}
		    }
		}
    };

	new Chart($('#rpt-chart')[0], config);
}

function rptShowChartColumn(data)
{
	var config = {
		type: 'bar',
		data: {
			labels: data.labels,
			datasets: data.datasets
		},
		options: {
			locale: $('html:first').attr('lang'),
			responsive: true,
		    plugins: {
				title: {
					display: false,
					text: ''
				},
				legend: {
					display: false
				},
				tooltip: {
					backgroundColor: '#f8f8f8',
					borderWidth: 1,
					borderColor: '#7cb5ec',
					titleColor: '#333333',
					bodyColor: '#333333',
					boxPadding: 5
				}
		    },
		    scales: {
				y: {
					type: 'linear',
					display: true,
					position: 'left'
				},
				x: {
					grid: {
			        	display: false
			        }
				}
		    }
		}
    };

	new Chart($('#rpt-chart')[0], config);
}
