<div class="rpt-filters">

	{{--<div class="rpt-views-trigger">
		@include('reports::partials/views')
	</div>--}}
	@php
		$mailboxes = Auth::user()->mailboxesCanView(true);
	@endphp

	<div class="rpt-filter">
		{{ __('Type') }} 
		<select class="form-control" name="type">
			<option value=""></option>
			<option value="{{ App\Conversation::TYPE_EMAIL }}">{{ __('Email') }}</option>
			<option value="{{ App\Conversation::TYPE_CHAT }}">{{ __('Chat') }}</option>
			<option value="{{ App\Conversation::TYPE_PHONE }}">{{ __('Phone') }}</option>
		</select>
	</div>
	<div class="rpt-filter">
		{{ __('Mailbox') }} 
		<select class="form-control" name="mailbox">
			<option value=""></option>
			@foreach ($mailboxes as $mailbox)
				<option value="{{ $mailbox->id }}">{{ $mailbox->name }}</option>
			@endforeach
		</select>
	</div>
	@if (\Route::currentRouteName() != 'reports.conversations')
		<div class="rpt-filter">
			{{ __('User') }} 
			<select class="form-control" name="user">
				<option value="">{{ __('All Users') }}</option>
				@foreach (Auth::user()->whichUsersCanView($mailboxes) as $user)
					<option value="{{ $user->id }}" data-mailboxes="{{ implode(',', $user->mailboxesCanView(true)->pluck('id')->toArray()) }}">{{ $user->getFullName() }}</option>
				@endforeach
			</select>
		</div>
	@endif
	@if (\Module::isActive('tags'))
		<div class="rpt-filter">
    		{{ __('Tag') }} 
    		<select class="form-control" name="tag">
    			<option value=""></option>
    			@foreach (Modules\Tags\Entities\Tag::orderBy('name')->get() as $tag)
    				<option value="{{ $tag->id }}">{{ $tag->name }}</option>
    			@endforeach
    		</select>
    	</div>
    @endif

	<div class="rpt-filter">
		<select class="form-control" name="period">
			<option value="custom">{{ __('Custom') }}</option>
			<option value="today">{{ __('Today') }}</option>
			<option value="yesterday">{{ __('Yesterday') }}</option>
			<option value="last_7">{{ __('Last 7 days') }}</option>
			<option value="last_week">{{ __('Last Week') }}</option>
			<option value="this_month">{{ __('This Month') }}</option>
			<option value="last_month">{{ __('Last Month') }}</option>
			<option value="last_12_months">{{ __('Last 12 Months') }}</option>
			<option value="this_year">{{ __('This Year') }}</option>
		</select>
		<nobr><input type="text" name="from" class="form-control rpt-filter-date" value="{{ $filters['from'] }}" />-<input type="text" name="to" class="form-control rpt-filter-date" value="{{ $filters['to'] }}" /></nobr>
		{{--<button class="btn btn-primary" name="period">Oct 1, 2017 - Nov 1, 2017 <span class="caret"></span></button>--}}
	</div>
	{{--<div class="rpt-filter" data-toggle="tooltip" title="{{ __('Export') }}">
		<button class="btn btn-primary"><i class="glyphicon glyphicon-download-alt"></i></button>
	</div>--}}

	<div class="rpt-filter rpt-filter-btn" data-toggle="tooltip" title="{{ __('Refresh') }}">
		<button class="btn btn-primary" id="rpt-btn-loader"><i class="glyphicon glyphicon-refresh"></i></button>
	</div>
	<div class="rpt-filter rpt-filter-btn" data-toggle="tooltip" title="{{ __('Clear Filters') }}">
		<button class="btn btn-default" id="rpt-btn-clear"><i class="glyphicon glyphicon-remove"></i></button>
	</div>

	@action('reports.filters_button_append')
</div>

@php
	$custom_fields = Reports::getCustomFieldFilters();
@endphp

@if (count($custom_fields))
    <div class="rpt-filters">
        @foreach($custom_fields as $custom_field)
            <div class="rpt-filter rpt-cf-mailbox rpt-cf-mailbox-{{ $custom_field->mailbox_id }} hidden">
                <span class="rpt-cf-name">{{ $custom_field->name }}</span>

                @if ($custom_field->type == CustomField::TYPE_DROPDOWN)
                    <select name="custom_field[{{ $custom_field->id }}]" class="form-control">
                        <option value=""></option>
                        @if (is_array($custom_field->options))
                            @foreach ($custom_field->options as $option_id => $option_name)
                                <option value="{{ $option_id }}">{{ $option_name }}</option>
                            @endforeach
                        @endif
                    </select>
                @else
                    <input name="custom_field[{{ $custom_field->id }}]" value="{{ $filters[$custom_field->name] ?? '' }}" class="form-control @if ($custom_field->type == CustomField::TYPE_DATE) input-date @endif" />
                @endif
            </div>
        @endforeach
    </div>
@endif
