<?php

namespace Modules\SortableCustomField;

use Illuminate\Support\Facades\DB;
use Module;

class Init extends Module
{
    public static function boot()
    {
        // Dynamically load all custom fields for conversations
        $customFields = DB::table('custom_fields')
            ->where('model', 'conversation')
            ->get();

        // Hook into headers
        \Event::listen('conversation.list.headers', function (&$columns) use ($customFields) {
            foreach ($customFields as $field) {
                $key = 'custom_field_' . $field->key;
                $columns[$key] = [
                    'label' => $field->label,
                    'sortable' => true,
                ];
            }
        });

        // Hook into row rendering
        \Event::listen('conversation.list.row', function (&$row, $conversation) use ($customFields) {
            foreach ($customFields as $field) {
                $value = DB::table('conversation_custom_fields')
                    ->where('conversation_id', $conversation->id)
                    ->where('key', $field->key)
                    ->value('value');

                $row['custom_field_' . $field->key] = $value;
            }
        });

        // Hook into query sorting
        \Event::listen('conversation.list.query', function (&$query, $params) use ($customFields) {
            if (!empty($params['order_by'])) {
                foreach ($customFields as $field) {
                    $key = 'custom_field_' . $field->key;
                    if ($params['order_by'] === $key) {
                        $query->leftJoin('conversation_custom_fields as ccf_' . $field->key, function ($join) use ($field) {
                            $join->on('ccf_' . $field->key . '.conversation_id', '=', 'conversations.id')
                                 ->where('ccf_' . $field->key . '.key', '=', $field->key);
                        });
                        $query->orderBy(DB::raw('ccf_' . $field->key . '.value'), $params['order_dir'] ?? 'asc');
                        break;
                    }
                }
            }
        });
    }
}
